<?php
include 'conexao.php';
include 'menu.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM servicos WHERE id = ?");
$stmt->execute([$id]);
$servico = $stmt->fetch();

if (!$servico) {
    die("<div class='alert alert-danger'>Serviço não encontrado.</div>");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("UPDATE servicos SET nome=?, descricao=?, valor=? WHERE id=?");
    $stmt->execute([$_POST['nome'], $_POST['descricao'], $_POST['valor'], $id]);
    echo "<div class='alert alert-success'>Serviço atualizado!</div>";
}
?>
<h2>Editar Serviço</h2>
<form method="POST" class="row g-3">
  <div class="col-md-6">
    <input type="text" class="form-control" name="nome" value="<?= $servico['nome'] ?>" required>
  </div>
  <div class="col-md-6">
    <input type="number" step="0.01" class="form-control" name="valor" value="<?= $servico['valor'] ?>" required>
  </div>
  <div class="col-12">
    <textarea class="form-control" name="descricao"><?= $servico['descricao'] ?></textarea>
  </div>
  <div class="col-12">
    <button type="submit" class="btn btn-primary">Salvar Alterações</button>
  </div>
</form>
<?php include 'footer.php'; ?>
