<?php include 'menu.php'; ?>
<h2 class="mb-4">Cadastro de Clientes</h2>
<form method="POST" class="row g-3">
  <div class="col-md-6">
    <input type="text" class="form-control" name="nome" placeholder="Nome" required>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="whatsapp" placeholder="WhatsApp" required>
  </div>
  <div class="col-md-6">
    <input type="email" class="form-control" name="email" placeholder="Email">
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="endereco" placeholder="Endereço">
  </div>
  <div class="col-12">
    <button type="submit" name="salvar" class="btn btn-primary">Salvar</button>
  </div>
</form>
<?php
include 'conexao.php';
if (isset($_POST['salvar'])) {
    $stmt = $pdo->prepare("INSERT INTO clientes (nome, whatsapp, email, endereco) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_POST['nome'], $_POST['whatsapp'], $_POST['email'], $_POST['endereco']]);
    echo "<div class='alert alert-success mt-3'>Cliente salvo com sucesso!</div>";
}
?>
<?php include 'footer.php'; ?>

<hr><h3>Clientes Cadastrados</h3>
<table class="table table-bordered">
<thead><tr><th>Nome</th><th>WhatsApp</th><th>Email</th><th>Ações</th></tr></thead><tbody>
<?php
foreach ($pdo->query("SELECT * FROM clientes ORDER BY id DESC") as $cli) {
    echo "<tr>
            <td>{$cli['nome']}</td>
            <td>{$cli['whatsapp']}</td>
            <td>{$cli['email']}</td>
            <td>
              <a href='editar_cliente.php?id={$cli['id']}' class='btn btn-sm btn-warning'>Editar</a>
              <a href='excluir_cliente.php?id={$cli['id']}' class='btn btn-sm btn-danger' onclick='return confirm("Confirmar exclusão?")'>Excluir</a>
            </td>
          </tr>";
}
?>
</tbody></table>
<?php include 'footer.php'; ?>
