<?php
include 'conexao.php';
include 'menu.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = ?");
$stmt->execute([$id]);
$cliente = $stmt->fetch();

if (!$cliente) {
    die("<div class='alert alert-danger'>Cliente não encontrado.</div>");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("UPDATE clientes SET nome=?, whatsapp=?, email=?, endereco=? WHERE id=?");
    $stmt->execute([$_POST['nome'], $_POST['whatsapp'], $_POST['email'], $_POST['endereco'], $id]);
    echo "<div class='alert alert-success'>Cliente atualizado!</div>";
}
?>
<h2>Editar Cliente</h2>
<form method="POST" class="row g-3">
  <div class="col-md-6">
    <input type="text" class="form-control" name="nome" value="<?= $cliente['nome'] ?>" required>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="whatsapp" value="<?= $cliente['whatsapp'] ?>" required>
  </div>
  <div class="col-md-6">
    <input type="email" class="form-control" name="email" value="<?= $cliente['email'] ?>">
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="endereco" value="<?= $cliente['endereco'] ?>">
  </div>
  <div class="col-12">
    <button type="submit" class="btn btn-primary">Salvar Alterações</button>
  </div>
</form>
<?php include 'footer.php'; ?>
